 /*-----------------------------------------------------------------------------*
 * File Name: ProjectBrowser.h		 											*
 * Creation: Frank	 5/24/05													*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 12/2/05 DBL_CLICK_CLOSE_ENDED_LIKE_CANCEL								*
 *	Jasmine 12/16/05 QA70-8352 v8.0347 CONTROL_TREE_LEVEL						*
 *	Jasmine 03/16/06 v8.0375 FORCE_TO_CALL_RESIZE								*
 * 	Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER								*
 *	Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER							*
 *	Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER			*
 *	Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER									*
 *	Jasmine 05/08/07 QA80-9654 OPEN_COLUMN_BROWSER								*
 *	Folger 05/09/07 QA80-9654 FIX_BUGS_IN_COLUMN_BROWSER						*
 *	Jasmine 05/09/07 FIX_PANE_SIZE_BUG											*
 *	Folger 05/15/07 FIX_BUG_IN_PB_COLUMN_BROWSER								*
 *	Folger 05/28/07 FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED				*
 *	Folger 05/30/07 FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED1				*
 *	Folger 05/30/07 FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED2				*
 *	Folger 06/06/07 FIX_BUGS_IN_DEFAULT_SHOW									*
 *	Folger 06/08/07 MODIFY_COLUMN_SHORT_NAME									*
 *	Folger 06/18/07 MODIFY_ADD_SELECTED_MECHANISM								*
 *	Folger 06/20/07 CORRECT_CODE_ORDER											*
 *	Folger 06/20/07 MODIFY_INIT_COLS_LIST										*
 *	Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE								*
 *	Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION							*
 *	Jasmine 07/05/07 INIT_STR_SELECTED_PAGE										*
 *	Folger 07/05/07 PB_RANGE_LIST_BASE_IS_NEED_TO_CENTRALIZE_PAGE_SHEET_COLUMN_RANGE_GRIDS
 *	Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING			*
 *	Folger 07/05/07 FIX_WHEN_SELECTED_ROW_INDEX_IS_LESS_THAN_ROW_OFFSET			*
 *	Folger 07/13/07 CREATE_MATRIX_OBJECT_LIST_TO_SUPPORT_MATRIX_RANGE_SELECTION	*
 *	Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED			*
 *	Folger 07/16/07 REMOVE_BUTTON_NEED_ENABLE_CONTROL							*
 *	Folger 07/16/07 MOVE_ALL_PB_RANGE_LIST_CLASS_INTO_PBRANGELIST_H				*
 *	Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER	*
 *	Jasmine 09/28/07 QA70-10305 FILTER_OUT_NON_IMAGE_MATRIX						*
 *	Kyle 07/16/08 QA80-11840 CALL_SETSHOWCOLUMNS_TO_INIT_SHOWCOLUMNS			*
 *	Folger 08/15/08 DISABLE_HELP_ON_PROJECT_BROWSER_DEMANDED_BY_FAY				*
 *	Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION			*
 *	Jasmine 04/28/10 QA81-14826-P3 PB_DLG_ADD_LIST_VIEW_CHECKBOX				*
 *------------------------------------------------------------------------------*/
 
#ifndef _PB_H
#define _PB_H

#include "PBListBase.h"
#include "PBSplliter.h"

#include "PBRangeList.h"		//--------Folger 07/16/07 MOVE_ALL_PB_RANGE_LIST_CLASS_INTO_PBRANGELIST_H

#include <Profiler.h>
#define HOUR_GLASS			waitCursor junk;
#define _SHOW_TIME			Profiler junk;

///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
//class ProjectBrowserDlg : public ResizeDialog
class ProjectBrowserDlg : public MultiPaneDlg
///End ADD_PREVIEW_ON_PROJECT_BROWSER
{
public :
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//ProjectBrowserDlg(LPCSTR lpcszDlgTitle = NULL , vector<int> &vnTypeList = NULL, int nSelectedMode =SINGLE_SELECT, int nOnlyShowLayers  =  EXIST_NONE) : ResizeDialog(IDD_PB_DLG, "Odlg8") 
	ProjectBrowserDlg(LPCSTR lpcszDlgTitle = NULL , bool bShowGraphPreview = false) : MultiPaneDlg(IDD_PB_DLG, "Odlg8") 
	//ProjectBrowserDlg(LPCSTR lpcszDlgTitle = NULL ) : ResizeDialog(IDD_PB_DLG, "Odlg8") 
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	{
		vector<uint> vnFolderListGroup = {IDC_PB_FOLDER_TEXT, IDC_PB_FOLDER_COMBO, IDC_PB_UP_BTN, 0};
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//vector<uint> vnNameGroup = {IDC_PB_NAME_TEXT, IDC_PB_NAME_EDIT, 0};
		//vector<uint> vnTypeGroup = {IDC_PB_TYPE_TEXT, IDC_PB_TYPE_COMBO, IDCANCEL, 0};	
		vector<uint> vnBottomGroup = {IDCANCEL, IDOK};//{IDC_PB_TYPE_TEXT, IDC_PB_TYPE_COMBO, IDOK, IDCANCEL};///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION	
		///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER		
		if( bShowGraphPreview)
		{
			vector<uint> vnMoreBottomGroup = {IDCANCEL, IDOK, IDC_PB_REMOVE, IDC_PB_ADD};	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
			vnBottomGroup = vnMoreBottomGroup;
		}
			
		m_bShowGraphPreview = bShowGraphPreview;
		vnBottomGroup.Add(0);
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		m_vnFolderListGroup = vnFolderListGroup;
		
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//m_vnNameGroup = vnNameGroup;
		//m_vnTypeGroup = vnTypeGroup;
		m_vnBottomGroup = vnBottomGroup;
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		if(lpcszDlgTitle)
			m_strDlgTitle = lpcszDlgTitle;
		
		//m_PBList.InitSplitterSetting(nSelectedMode,nOnlyShowLayers,  vnTypeList);
		
		m_pRangeList = NULL;

	}
	
	~ProjectBrowserDlg()
	{
		if (m_pRangeList)
			delete m_pRangeList;
	}
	
	int  DoModal(HWND hParent = NULL) 
	{
		InitMsgMap();
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//int nRet = ResizeDialog::DoModal(hParent);
		int nRet = MultiPaneDlg::DoModal(hParent);
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		return nRet;
	}
	int Create(HWND hParent=NULL) //call from CB, etc
	{
		InitMsgMap();
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		int nRet = MultiPaneDlg::Create(hParent);
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		return nRet;
	}
	
protected:
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_READY(OnReady)///Jasmine 12/16/05
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	ON_OK(OnOk)
	ON_CANCEL(OnCancel)

	ON_BN_CLICKED(IDC_PB_UPDOWN, OnShowPreview)  ///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	ON_BN_CLICKED(IDC_PB_ADD, OnAdd)	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	ON_BN_CLICKED(IDC_PB_REMOVE, OnRemove)
	ON_BN_CLICKED(IDC_PB_SHORTCUT_CHECK, OnIncludeShortcut)	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	ON_CBN_SELCHANGE(IDC_PB_TYPE_COMBO, OnTypeChange)
	ON_USER_MSG(WM_USER_ON_NAME_CHANGE, OnNameChanged)
	ON_USER_MSG(WM_USER_ON_DBCLICK_SELETED, OnDblClickToClose)
	
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//ON_BN_CLICKED(IDC_PB_UP_BTN, OnClickUp)
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	ON_KEY(IDC_PB_NAME_EDIT, OnKeyNameCmd)
	
	///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
	ON_INIT_SIZE(OnInitSize)
	ON_RESTORESIZE(OnRestoreSize)
	ON_GETMINMAXINFO(OnMinMaxInfo)
	
//	ON_GRID_DBLCLICK(IDC_PB_GRID, OnDblClickToRemove)	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	///End MODIFY_PB_COLUMN_BROWSER
	///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION
	ON_GRID_BUTTON_CLICK(IDC_PB_GRID, OnButtonClickColList)	
	ON_GRID_BEFORE_EDIT(IDC_PB_GRID, OnBeforeEditParaControl)
	///End SUPPORT_RANGE_SELECTION
	
	ON_HELPINFO(OnHelp)		//------ Folger 08/15/08 DISABLE_HELP_ON_PROJECT_BROWSER_DEMANDED_BY_FAY

	/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	ON_BN_CLICKED(IDC_PB_LIST_VIEW_CHECK, OnListView);
	/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	
EVENTS_END

	//------ Folger 08/15/08 DISABLE_HELP_ON_PROJECT_BROWSER_DEMANDED_BY_FAY
	BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	{
		return false;
	}
	//------
	
	/// Bill 07/09/2010 QA81-14826-P2 SHOW_LONG_NAME_AND_LIST_VIEW_MENU
	void OnListView(Control ctrl)
	{
		m_PBList.OnListViewChecked();
	}
	/// End SHOW_LONG_NAME_AND_LIST_VIEW_MENU

	bool 	OnInitDialog()
	{
		HOUR_GLASS	
		
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//OnInitDialog(IDC_PB_BOX);
		///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
		//vector<string> vsTooltipsShowBottomPane = {"Show Grid", "No Grid"};
		vector<string> vsTooltipsShowBottomPane;
		vsTooltipsShowBottomPane.Add(_L("Show Grid"));
		vsTooltipsShowBottomPane.Add(_L("No Grid"));
		///Jasmine 05/09/07 FIX_PANE_SIZE_BUG
		if (m_PBList.GetPageFilterType() == EXIST_GRAPH && m_PBList.CountTypeList() == 1)//if type list has other type besides EXIST_GRAPH, it should show the type list
		{
			vsTooltipsShowBottomPane[0] = _L("Show Preview");
			vsTooltipsShowBottomPane[1] = _L("Show Preview");
			GetItem(IDC_PB_TYPE_TEXT).Visible = false;
			GetItem(IDC_PB_TYPE_COMBO).Visible = false;
			GetItem(IDC_PB_GRID).Visible = false;
			GetItem(IDC_PB_ADD).Visible = false;
			GetItem(IDC_PB_REMOVE).Visible = false;
			GetItem(IDC_PB_APPEND).Visible = false;
			MultiPaneDlg::OnInitDialog(IDC_PB_BOX,IDC_PB_UPDOWN,IDC_PB_PREVIEW,vsTooltipsShowBottomPane,STR_DLG_NAME);
		}
		else
		{
			if(! m_bShowGraphPreview)
			{				
				GetItem(IDC_PB_UPDOWN).Visible = false;
				GetItem(IDC_PB_GRID).Visible = false;
				GetItem(IDC_PB_PREVIEW).Visible = false;
				GetItem(IDC_PB_ADD).Visible = false;
				GetItem(IDC_PB_REMOVE).Visible = false;
				GetItem(IDC_PB_APPEND).Visible = false;
			}
			else
			{
				GetItem(IDC_PB_TYPE_TEXT).Visible = false;
				GetItem(IDC_PB_TYPE_COMBO).Visible = false;
				ASSERT(m_PBList.CountTypeList() == 1);//combo is hidden so you can not select other type
				GetItem(IDC_PB_GRID).Visible = true;
				GetItem(IDC_PB_PREVIEW).Visible = false;
				GetItem(IDC_PB_ADD).Visible = true;
				GetItem(IDC_PB_REMOVE).Visible = true;				
			}
			MultiPaneDlg::OnInitDialog(IDC_PB_BOX,IDC_PB_UPDOWN,IDC_PB_GRID,vsTooltipsShowBottomPane,STR_DLG_NAME);			
		}
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		GetItem(IDC_PB_LIST_VIEW_CHECK).Visible = true;
		
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//if(! m_bShowGraphPreview)
		//{
////			ShowBottomPane(false);		///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
		//}
		if(m_bShowGraphPreview)
		{
			if (m_PBList.GetPageFilterType() == EXIST_GRAPH)
			{
				Control ctrlPre = GetItem(IDC_PB_PREVIEW);
	    		m_pcPrev.CreateControl(ctrlPre.GetSafeHwnd());
			}
		///Folger 05/30/07 FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED1
			////else
	    		////initColsList();
		}
		///Folger 06/20/07 CORRECT_CODE_ORDER
		//initColsList();
		///End FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED1
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		///End FIX_PANE_SIZE_BUG
		
		///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		Button chkIncludeShortcut = GetItem(IDC_PB_SHORTCUT_CHECK);
		//here may add code to load register value
		if(chkIncludeShortcut)
			m_PBList.m_bIncludeShortcut = chkIncludeShortcut.Check;
		///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
		
		//m_PBList.Init(IDC_PB_BOX, *this, STR_DLG_NAME ,IDC_PB_FOLDER_COMBO, IDC_PB_FOLDER_TEXT, IDC_PB_TYPE_COMBO, IDC_PB_TYPE_TEXT, IDC_PB_NAME_EDIT,IDC_PB_NAME_TEXT, IDC_PB_UP_BTN);
		//m_PBList.Init(IDC_PB_BOX, *this, STR_DLG_NAME ,m_nPBListType, IDC_PB_FOLDER_COMBO, IDC_PB_FOLDER_TEXT, IDC_PB_TYPE_COMBO, IDC_PB_TYPE_TEXT, IDC_PB_NAME_EDIT,IDC_PB_NAME_TEXT, IDC_PB_UP_BTN);
		///Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
		/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
		//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
		//m_PBList.Init(IDC_PB_BOX, *this, STR_DLG_NAME ,m_nPBListType, IDC_PB_FOLDER_COMBO, IDC_PB_FOLDER_TEXT, IDC_PB_TYPE_COMBO, IDC_PB_TYPE_TEXT, IDC_PB_NAME_EDIT,IDC_PB_NAME_TEXT, IDC_PB_UP_BTN);
		m_PBList.Init(IDC_PB_BOX, *this, m_strDlgTitle ,m_nPBListType, IDC_PB_FOLDER_COMBO, IDC_PB_FOLDER_TEXT, IDC_PB_TYPE_COMBO, IDC_PB_TYPE_TEXT, IDC_PB_NAME_EDIT,IDC_PB_NAME_TEXT, IDC_PB_UP_BTN, m_dwFilter);///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
		//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
		initColsList();
		///End CORRECT_CODE_ORDER
		//	m_PBList.SetPageListDefault();////Temp test
		if( m_strDefaultShow.IsEmpty() )
			m_PBList.SetPageListDefault();
		else
			m_PBList.SetPageListDefault(m_strDefaultShow);
		/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
		///End SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
		m_bNoCleanList = false; //----- CPY 12/2/05 DBL_CLICK_CLOSE_ENDED_LIKE_CANCEL 

		if(!m_strDlgTitle.IsEmpty())
			m_wndDlg.Text = m_strDlgTitle;
		//OnReady();
		///End IMPROVE_PB_FOR_COLUMN_BROWSER
		return true;
	}
	BOOL OnReady()
	{
		UpdateDlgSize();	///Folger 05/09/07 QA80-9654 FIX_BUGS_IN_COLUMN_BROWSER
		UpdateDlgShow();					
		SetInitReady();
		m_PBList.OnReady();
		GetItem(IDOK).Enable = !m_strSelectedPages.IsEmpty();
		GetItem(IDC_PB_REMOVE).Enable = false;		//------Folger 07/16/07 REMOVE_BUTTON_NEED_ENABLE_CONTROL
		///Jasmine 05/09/07 FIX_PANE_SIZE_BUG, no need
		/*
		///Folger 05/09/07 QA80-9654 FIX_BUGS_IN_COLUMN_BROWSER
		if (IsBottomPaneShown())			///Trick, hard code
		{
			ShowBottomPane(false);
			ShowBottomPane(true);
		}
		///End FIX_BUGS_IN_COLUMN_BROWSER
		*/
		ShowWindow(SW_NORMAL);
		///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
		if (!m_bShowGraphPreview)
			ShowBottomPane(false);
		///End MODIFY_PB_COLUMN_BROWSER

		return true;
	}
	bool 	OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		_DMSG_PB("On dlg resize begin");
		MoveControlsHelper	_temp(this);
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//ResizeDialog::OnResize(nType, cx, cy);
		MultiPaneDlg::OnDlgResize(m_vnBottomGroup, cx, cy, false);	
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		//if(!m_bShowGraphPreview)///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
			repositionControl(cx, cy);
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//m_PBList.OnDlgResize(nType, cx, cy);	///Jasmine 03/16/06 FORCE_TO_CALL_RESIZE
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
//		SetBottomPaneHeight(100);		///Folger 05/09/07 QA80-9654 FIX_BUGS_IN_COLUMN_BROWSER
		///End MODIFY_PB_COLUMN_BROWSER
		_DMSG_PB("On dlg resize end");
		return TRUE;
	}
	///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
	BOOL OnInitSize(int &left, int &top, int &right, int  &bottom)
	{
		return FALSE;
	}
	
	BOOL OnRestoreSize(DWORD dwSizeInfo)
	{
		void * p = (void*)dwSizeInfo;
		DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
		lstrcpyn(pSz->szDialogName, STR_DLG_NAME, MAXLINE);
		if(0 == HasPreviousSize(pSz->szDialogName))
			pSz->bStartHidden = true;

		//SIZE sz;
		//GetDlgOptimalSize(sz);
		///Joseph 02/15/07 ROLL_BRAK_TO_TD_DESIGN
		pSz->top = -1;
		pSz->left = -1;
		pSz->width = 600;
		pSz->height = 500;
		
		return TRUE;
	}
	///End MODIFY_PB_COLUMN_BROWSER
	
	int	GetTotalHeight(bool bMin = false)
	{
		int nHeight = 200;
		
		if( IsBottomPaneShown() )
		{
			RECT rSownBtn;
			GetClientRect(GetItem(IDC_PB_UPDOWN), rSownBtn);
			return rSownBtn.bottom + nHeight + 2*GetControlGap();
		}
		
		return nHeight;
	}
	
	int	GetTotalWidth(bool bMin = false)
	{
		vector<uint> vnControls = {IDC_PB_SHORTCUT_CHECK, IDC_PB_LIST_VIEW_CHECK, IDC_PB_UPDOWN};
		vnControls.Append(m_vnBottomGroup);
		
		int nWidth, nHeight;
		GetGroupTotalSize(vnControls, nWidth, nHeight, true, GetControlGap()*5);
		
		return nWidth;
	}
	
	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	bool OnAdd(Control cntrl)
	{
		addSelected();
//		OUT(m_strSelectedPages);	///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
		return true;
	}
	
	bool OnRemove(Control cntrl)
	{
		removeSelected();
//		OUT(m_strSelectedPages);	///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
		return true;
	}
	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	bool OnIncludeShortcut(Control cntrl)
	{
		Button chkIncludeShortcut = GetItem(IDC_PB_SHORTCUT_CHECK);
		if(chkIncludeShortcut)
		{
			m_PBList.m_bIncludeShortcut = chkIncludeShortcut.Check;
			m_PBList.OnTypeChange();
		}
		return true;
	}
	///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
	//bool OnDblClickToRemove(Control cntrl)
	//{
		//removeSelected();
		//OUT(m_strSelectedPages);
		//return true;
	//}
	///End IMPROVE_PB_FOR_COLUMN_BROWSER
	///End MODIFY_PB_COLUMN_BROWSER
	///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION
	void OnButtonClickColList(Control flxControl, int nRow, int nCol)
	{
		//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//m_colList.OnButtonClick(flxControl, nRow, nCol);
		m_pRangeList->OnButtonClick(flxControl, nRow, nCol);
		vector<string> vsVals;
		//m_colList.GetColValues(COL_RANGE + m_colList.GetColOffset(), vsVals, m_colList.GetRowOffset());
		m_pRangeList->GetColValues(COL_RANGE + m_pRangeList->GetColOffset(), vsVals, m_pRangeList->GetRowOffset());
		//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		if(vsVals.GetSize())
			m_strSelectedPages.SetTokens(vsVals, CHAR_RANGE_SEPARATOR);
	}
	void OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{
		//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//m_colList.OnBeforeEditParaControl(flxControl, nRow, nCol,pCancel );
		m_pRangeList->OnBeforeEditParaControl(flxControl, nRow, nCol,pCancel );
		GetItem(IDC_PB_REMOVE).Enable = true;		//------Folger 07/16/07 REMOVE_BUTTON_NEED_ENABLE_CONTROL
		//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
	}
	///End SUPPORT_RANGE_SELECTION
	bool 	OnOk()
	{
		if(m_strSelectedPages.IsEmpty())
			return false;
		return true;
	
	}
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	BOOL OnShowPreview(Control cntrl)
	{	
		MultiPaneDlg::OnShowBottomPane(cntrl);		
		
		if(IsBottomPaneShown() && m_PBList.GetPageFilterType() == EXIST_GRAPH)	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER			
			updatePreview();		
		return TRUE;
	}
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	bool OnCancel()
	{
		if(!m_bNoCleanList) //----- CPY 12/2/05 DBL_CLICK_CLOSE_ENDED_LIKE_CANCEL 
			m_strSelectedPages.Empty();
		return true;
	}
	bool 	OnDblClickToClose(uint wParam, uint lParam) //CPY 12/2/05 DBL_CLICK_CLOSE_ENDED_LIKE_CANCEL was OnClose
	{
//		m_bNoCleanList = true; //----- CPY 12/2/05 DBL_CLICK_CLOSE_ENDED_LIKE_CANCEL 	///Folger 05/09/07 QA80-9654 FIX_BUGS_IN_COLUMN_BROWSER
		
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//m_strSelectedPages = m_PBList.GetSelectedPages(); ///Jasmine 11/29/05
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
		if (m_PBList.GetPageFilterType() == EXIST_GRAPH || !m_bShowGraphPreview)
		{
			m_bNoCleanList = true;
			PostMessage( WM_CLOSE );
		}
		else
		{
			addSelected();
//			OUT(m_strSelectedPages);		///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
		}
		///End IMPROVE_PB_FOR_COLUMN_BROWSER
		return true;
	}
	void 	OnTypeChange(Control ctrl)
	{
		m_PBList.OnTypeChange();
	}
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//void	OnComboFolderSelectedChanged(Control ctrl)
	//{
		//m_PBList.OnFolderSelectedChanged();
	//}
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	BOOL	OnNameChanged(uint wParam, uint lParam)
	{
		_DMSG_PB("Browser list changed");
		///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
		//m_strSelectedPages = m_PBList.GetSelectedPages();
		///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
		if (m_PBList.GetPageFilterType() == EXIST_GRAPH)
		{
			m_strSelectedPages = m_PBList.GetGraphName();
			if(IsBottomPaneShown())		
				updatePreview();
		}
		else if (!m_bShowGraphPreview)
		{
			///Folger 06/18/07 MODIFY_ADD_SELECTED_MECHANISM
			///Folger 05/28/07 FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED
			//m_strSelectedPages = m_PBList.GetGraphName();
			//string strLayer = m_PBList.GetSelWks();
			//Worksheet wks(strLayer);
			//int nSelected = atoi(m_PBList.GetGraphName()) - 1;
			/////Folger 05/30/07 FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED2
			//if (nSelected >= 0)
			//{
				////m_strSelectedPages = strLayer + '!' + wks.Columns(nSelected).GetName();
				//wks.Columns(nSelected).GetRangeString(m_strSelectedPages);
				/////Folger 06/08/07 MODIFY_COLUMN_SHORT_NAME
				//DataRange dr;
				//dr.Create();
				//dr.Add("", m_strSelectedPages);
				//m_strSelectedPages = dr.GetDescription(GETLC_PAGE_SHORT_NAME | GETLC_COL_SHORT_NAME | GETLC_COL_NO_FUNC);
				/////End MODIFY_COLUMN_SHORT_NAME
			//}
			//else
			//{
				//m_strSelectedPages = "";
			//}
			///End FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED2
			///End FIX_BUG_IN_PB_COLUMN_BROWSER_SINGLE_SELECTED
			//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
			//m_strSelectedPages = m_PBList.GetSelectedPage();
			vector<string> vsSelected;
			if (m_PBList.GetSelectionRangeString(vsSelected))
				m_strSelectedPages = vsSelected[0];
			//--------end CLEAN_UP_GET_RANGE_STRING_CODE
			///End MODIFY_ADD_SELECTED_MECHANISM
		}
		///End IMPROVE_PB_FOR_COLUMN_BROWSER
		///End ADD_PREVIEW_ON_PROJECT_BROWSER
		GetItem(IDOK).Enable = !m_strSelectedPages.IsEmpty();
		return true;
	}
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//void OnClickUp(Control ctrl)
	//{
		//m_PBList.OnUpOneLevelFolder();
	//}
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	BOOL OnKeyNameCmd(Control oCntrl, UINT msg, UINT wParam, UINT lParam)
	{
		switch(wParam)
		{
		case VK_RETURN:
			out_str("Enter");
			return TRUE;
		case VK_ESCAPE:
			out_str("Click ESC");
			return TRUE;
		}
			
		return FALSE;
	}	

private:
	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	void initColsList()
	{
		//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//m_colList.Init(IDC_PB_GRID, *this);
		m_pRangeList->Init(IDC_PB_GRID, *this);
		//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION
		/*		
		m_colList.SetAllowSelection(true);	///If false , support single selete; else multi seletion
		m_colList.SetSelection( flexSelectionListBox );
		m_colList.SetEditable( );
		m_colList.SetupRowsCols(1, 1, -1, 2);
		m_colList.SetColHeading(COL_RANGE, "Range");
		*/
		///Kyle 07/16/08 QA80-11840 CALL_SETSHOWCOLUMNS_TO_INIT_SHOWCOLUMNS
		vector<uint> vnDisplayCols = {	PELAYER_NAME, 
										PELAYER_TYPE,
										PELAYER_SIZE, 
										PELAYER_VIEW, 
										PELAYER_FILENAME };
		m_PBList.SetShowColumns(vnDisplayCols);
		///End CALL_SETSHOWCOLUMNS_TO_INIT_SHOWCOLUMNS
		if(!m_strDefaultShow.IsEmpty())
		{
			vector<string> vsVals;
			int nCount = m_strDefaultShow.GetTokens(vsVals, CHAR_RANGE_SEPARATOR);
			///Jasmine 05/08/07 QA80-9654 OPEN_COLUMN_BROWSER
			///Folger 06/20/07 MODIFY_INIT_COLS_LIST
			//string strWks;
			//Worksheet wks = Project.ActiveLayer();
			//if(wks)
				//wks.GetRangeString(strWks);
			//for(int ii = 0; ii < nCount; ii++)
			//{
				//string str = vsVals[ii];
				//str.TrimLeft(); str.TrimRight();
				//
				//DataRange dr;
				//dr.Create();
				//dr.Add("", str);
				//if(1 > dr.GetNumRanges())
				//{
					//str = strWks + str;
					//dr.Add("", str);
				//}
				//vsVals[ii] = dr.GetDescription(GETLC_PAGE_SHORT_NAME | GETLC_COL_SHORT_NAME|GETLC_COL_NO_FUNC);		///Folger 06/06/07 FIX_BUGS_IN_DEFAULT_SHOW
			//}
			///Folger 06/20/07 MODIFY_INIT_COLS_LIST
			///End OPEN_COLUMN_BROWSER
			m_PBList.GetInitRangeString(vsVals);
			///Folger 05/15/07 FIX_BUG_IN_PB_COLUMN_BROWSER
			for (int ii=0; ii<vsVals.GetSize(); ii++)
			{
				if (vsVals[ii].IsEmpty())
				{
					vsVals.RemoveAt(ii);
					ii--;
				}
			}
			///End FIX_BUG_IN_PB_COLUMN_BROWSER
			//m_colList.SetColValues(COL_RANGE, vsVals, 0, true);
			m_strDefaultShow = vsVals[0];
			//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
			//int nRowStart = m_colList.GetRows();
			int nRowStart = m_pRangeList->GetRows();
			//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
			///Jasmine 07/05/07 INIT_STR_SELECTED_PAGE
			int nSize = vsVals.GetSize();
			for(ii=0; ii<nSize; ii++)
			//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
				//m_colList.AddRow(nRowStart++, vsVals[ii]);
			//m_colList.ResizeCols();
				m_pRangeList->AddRow(nRowStart++, vsVals[ii]);
			m_pRangeList->ResizeCols();
			//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
			if(nSize)
				m_strSelectedPages.SetTokens(vsVals, CHAR_RANGE_SEPARATOR);
			///End INIT_STR_SELECTED_PAGE
		}
		/*
		m_colList.ResizeCols();
		m_colList.SetReady();
		*/
		///End SUPPORT_RANGE_SELECTION
	}	
	///End IMPROVE_PB_FOR_COLUMN_BROWSER
	///Jasmine 04/27/10 QA81-14826-P5 BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	void	repositionControl(int cx, int cy)
	{	
		int nEdge=GetControlGap();
		
		RECT rrOK;
		GetControlClientRect(IDOK, rrOK);
		///Jasmine 04/28/10 QA81-14826-P3 PB_DLG_ADD_LIST_VIEW_CHECKBOX
		RECT rrCheck;
		GetControlClientRect(IDC_PB_SHORTCUT_CHECK, rrCheck);
		
		vector<uint> vnMoreControls = {IDC_PB_SHORTCUT_CHECK, IDC_PB_LIST_VIEW_CHECK, 0};
		ArrangeControlsLeftRight(vnMoreControls, nEdge, rrOK.bottom - RECT_HEIGHT(rrCheck), nEdge);
		
		Control comboType = GetItem(IDC_PB_TYPE_COMBO);
		if( comboType.Visible )
		{
			Control cAbove = GetItem(IDC_PB_BOX);
			RECT rrAbove;
			GetControlClientRect(IDC_PB_BOX, rrAbove);
			
			RECT rrInsert;
			GetControlClientRect(IDC_PB_TYPE_COMBO, rrInsert);
		
			int nTop = rrAbove.bottom - RECT_HEIGHT(rrInsert);
			
			rrAbove.bottom = nTop - nEdge;
			MoveControl(cAbove, rrAbove);
			
			vector<uint> vnComboGroup = {IDC_PB_TYPE_TEXT, IDC_PB_TYPE_COMBO, 0};
			ArrangeControlsLeftRight(vnComboGroup, nEdge, nTop, nEdge);
		}
		///End PB_DLG_ADD_LIST_VIEW_CHECKBOX
	}
	///End BROWSER_HAS_INCLUDE_SHORTCUT_OPTION
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	bool updatePreview()
	{
		PictureHolder 	pictHolder;
		
		GraphPage 		pg = Project.Pages(m_strSelectedPages);		
		/// end DOWNCAST_BUG
		if (!pg.IsValid())	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
			return false;
		page_get_picture(pg, pictHolder, "EMF", 72, false);
		
    	m_pcPrev.Visible = false;
    	if(pictHolder)
    	{
	    	m_pcPrev.SetPicture(pictHolder);
	    	m_pcPrev.KeepAspectRatio = true;
	    	m_pcPrev.Visible = true;
	    	return true;
    	}
    	return false;
	}
	///Folger 05/08/07 MODIFY_PB_COLUMN_BROWSER
	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	void addSelected()
	{
		//string strName = m_PBList.GetSelectedPage();	//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		vector<string> vsSelected;
		vector<string> vsVals;
		//--------Folger 07/03/07 CLEAN_UP_GET_RANGE_STRING_CODE
		//strName.GetTokens(vsSelected);
		m_PBList.GetSelectionRangeString(vsSelected);
		//--------end CLEAN_UP_GET_RANGE_STRING_CODE
		//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//m_colList.GetColValues(COL_RANGE + m_colList.GetColOffset(), vsVals, m_colList.GetRowOffset());
		m_pRangeList->GetColValues(COL_RANGE + m_pRangeList->GetColOffset(), vsVals, m_pRangeList->GetRowOffset());
		//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		int nSize = vsSelected.GetSize();
		///Folger 06/18/07 MODIFY_ADD_SELECTED_MECHANISM
		//string strLayer = m_PBList.GetSelWks();
		//Worksheet wks(strLayer);
		//if (!wks)
			//return;
		///Jasmine 05/08/07 QA80-9654 OPEN_COLUMN_BROWSER
		//vector<uint> vnIndeces, uBegins, uEnds;
		//for(int ii = 0; ii < nSize; ii++)
			//vnIndeces.Add(atoi(vsSelected[ii]));
		//int nRet = find_contiguous_range(vnIndeces, uBegins, uEnds);		
		//for (ii=0; ii<nRet; ii++)
		//{
			////string strTmp = wks.Columns(atoi(vsSelected[ii]) - 1).GetName();
			//int c1 = uBegins[ii] - 1, c2 = uEnds[ii] - 1;
			//string strTmp = make_range_string(wks, wks.Columns(c1).GetName(), wks.Columns(c2).GetName());
		/////End OPEN_COLUMN_BROWSER
			//if (strTmp != "" && vsVals.Find(strTmp) == -1)
			//{
				//int nRowStart = m_colList.GetRows();
				//m_colList.SetRows(nRowStart - m_colList.GetRowOffset() + 1);
				//m_colList.SetCell(nRowStart, COL_RANGE + m_colList.GetColOffset(), strTmp);
				//m_colList.ResizeCols();
				//vsVals.Add(strTmp);
			//}
		//}
		for (int ii=0; ii<nSize; ii++)
		{
			if (vsVals.Find(vsSelected[ii]) == -1)
			{
				//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
				//int nRowStart = m_colList.GetRows();
				int nRowStart = m_pRangeList->GetRows();
				//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
				///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION
				if(SINGLE_SELECT == m_nSelectedMode)
				{
					//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
					//int nOffset = m_colList.GetRowOffset();
					int nOffset = m_pRangeList->GetRowOffset();
					//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
					if(nRowStart > nOffset)
					{
						//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
						//m_colList.SetRows(nOffset);
						m_pRangeList->SetRows(nOffset);
						//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
						nRowStart = nOffset;
					}
					vsVals.SetSize(0);					
				}
				///End SUPPORT_RANGE_SELECTION
				///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION 
				/*
				m_colList.SetRows(nRowStart - m_colList.GetRowOffset() + 1);
				m_colList.SetCell(nRowStart, COL_RANGE + m_colList.GetColOffset(), vsSelected[ii]);
				m_colList.ResizeCols();
				*/
				//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
				//m_colList.AddRow(nRowStart, vsSelected[ii]);
				m_pRangeList->AddRow(nRowStart, vsSelected[ii]);
				//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
				///End SUPPORT_RANGE_SELECTION
				vsVals.Add(vsSelected[ii]);
			}
		}
		//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//m_colList.ResizeCols();
		m_pRangeList->ResizeCols();
		//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		///End MODIFY_ADD_SELECTED_MECHANISM
		if (nSize)
		{
			m_strSelectedPages.SetTokens(vsVals, CHAR_RANGE_SEPARATOR);
		}
		GetItem(IDOK).Enable = !m_strSelectedPages.IsEmpty();
	}
	///End MODIFY_PB_COLUMN_BROWSER
	
	void removeSelected()
	{
		//------Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
		//vector<uint> vnRows;
		//vector<string> vsVals;
		////-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		////m_colList.GetSelRows(vnRows);
		////m_colList.GetColValues(COL_RANGE + m_colList.GetColOffset(), vsVals, m_colList.GetRowOffset());
		////int nSelRow = m_colList.GetSelectedRow();
		//m_pRangeList->GetSelRows(vnRows);
		//m_pRangeList->GetColValues(COL_RANGE + m_pRangeList->GetColOffset(), vsVals, m_pRangeList->GetRowOffset());
		//int nSelRow = m_pRangeList->GetSelectedRow();
		////-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//for(int index = vnRows.GetSize() - 1; index >= 0; index--)
		//{
			////-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
			////m_colList.DeleteRow(vnRows[index]);
			////vsVals.RemoveAt(vnRows[index] - m_colList.GetRowOffset());
			//
			//if (vnRows[index] < m_pRangeList->GetRowOffset()) continue;		//---------Folger 07/05/07 FIX_WHEN_SELECTED_ROW_INDEX_IS_LESS_THAN_ROW_OFFSET
			//
			//m_pRangeList->DeleteRow(vnRows[index]);
			//vsVals.RemoveAt(vnRows[index] - m_pRangeList->GetRowOffset());
			////-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//}
		//if (vnRows.GetSize())
		//{
		vector<string> vsVals;
		m_pRangeList->RemoveSelectedRows(vsVals);
		//------End CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
			m_strSelectedPages.SetTokens(vsVals, CHAR_RANGE_SEPARATOR);
		//}		//------Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
		//------Folger 07/16/07 REMOVE_BUTTON_NEED_ENABLE_CONTROL
		//GetItem(IDOK).Enable = !m_strSelectedPages.IsEmpty();
		GetItem(IDC_PB_REMOVE).Enable = GetItem(IDOK).Enable = !m_strSelectedPages.IsEmpty();
		//------End REMOVE_BUTTON_NEED_ENABLE_CONTROL
		//selectRow(nSelRow);		//------Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
	}
	//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
	//void selectRow(int nRow = -1)
	//{
		//if( m_colList.GetRows() <= 0 )
			//return;
		//
		//while( nRow >= m_colList.GetRows() )
			//nRow--;
			//
		//if(nRow < 0)
			//nRow = m_colList.GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
		//if( nRow < 0 )
			//nRow = 0;
		//
		//if (nRow != 0) m_colList.SelRow(nRow);		
	//}
	//------Folger 07/17/07 CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
	//void selectRow(int nRow = -1)
	//{
		//if( m_pRangeList->GetRows() <= 0 )
			//return;
		//
		//while( nRow >= m_pRangeList->GetRows() )
			//nRow--;
			//
		//if(nRow < 0)
			//nRow = m_pRangeList->GetSelectedRow(); // get 1st if multiple selection, -1 if none selected
		//if( nRow < 0 )
			//nRow = 0;
		//
		//if (nRow != 0) m_pRangeList->SelRow(nRow);	
	//}
	//------End CLEAN_UP_DUPLICATED_CODES_IN_PROJECT_BROWSER_RANGE_BROWSER
	//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
	
	///End IMPROVE_PB_FOR_COLUMN_BROWSER
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
public:
	string GetSelectedPages()
	{
		return m_strSelectedPages;
	}
	///Jasmine 12/16/05 CONTROL_TREE_LEVEL
	/*
	void SetPBDlgOption(int nListType = PB_BROWSER_PAGE_LIST, vector<int> &vnTypeList = NULL, 
					int nSelectedMode =SINGLE_SELECT, int nOnlyShowLayers  =  EXIST_NONE, LPCSTR lpcszUpDlgTitle = NULL)
	{
		m_PBList.InitSplitterSetting(nSelectedMode,nOnlyShowLayers,  vnTypeList);
	*/
	///Jasmine 12/25/06 BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
	/*
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//void SetPBDlgOption(int nListType = PB_BROWSER_PAGE_LIST, vector<int> &vnTypeList = NULL, 
					//int nSelectedMode = SINGLE_SELECT, int nLevel = PTL_FOLDER, int nOnlyShowLayers  =  EXIST_NONE, LPCSTR lpcszUpDlgTitle = NULL)
	void SetPBDlgOption(int nListType = PB_BROWSER_PAGE_LIST, vector<int> &vnTypeList = NULL, 
					int nSelectedMode = MULTIPLE_SELECT, int nLevel = PTL_FOLDER, int nOnlyShowLayers  =  EXIST_NONE, LPCSTR lpcszUpDlgTitle = NULL)
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	*/
	///Jasmine 12/27/06 ADD_SOME_COMMENTS
	/*
	int nListType 			: Input which type of object, PB_BROWSER_PAGE_LIST or PB_BROWSER_LAYER_LIST, you want to select. 
							  This argument will specify the object type in the right list panel.
	vector<int> vnTypeList 	: Input the page type list, EXIST_WKS etc. If NULL the page type will include all page types.
							  The current selected type will specify the page type shown in the left tree panel.
	int nSelectedMode		: Selecting Mode in the right list panel
	int nLevel				: This argument will specify the level of the left tree panel
	LPCSTR lpcszUpDlgTitle	: The dialog's title
	*/
	///End ADD_SOME_COMMENTS
	//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
	//void SetPBDlgOption(int nListType = PB_BROWSER_PAGE_LIST, vector<int> &vnTypeList = NULL, 
	//				int nSelectedMode = MULTIPLE_SELECT, int nLevel = PTL_FOLDER, LPCSTR lpcszUpDlgTitle = NULL)
	void SetPBDlgOption(int nListType = PB_BROWSER_PAGE_LIST, vector<int> &vnTypeList = NULL, 
					int nSelectedMode = MULTIPLE_SELECT, int nLevel = PTL_FOLDER, LPCSTR lpcszUpDlgTitle = NULL, bool bResultSheet = false)
	//---------End EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED
	{
		//m_PBList.InitSplitterSetting(nSelectedMode,nLevel, nOnlyShowLayers,  vnTypeList);
		m_PBList.InitSplitterSetting(nSelectedMode,nLevel, vnTypeList);
	///End BOTH_TREE_PANEL_AND_PBLIST_SHOULD_SHOW_THE_SAME_TYPE
	///End CONTROL_TREE_LEVEL
		m_nPBListType = nListType;
		m_nSelectedMode = nSelectedMode;	///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION
		if(lpcszUpDlgTitle)
			m_strDlgTitle = lpcszUpDlgTitle;
		//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		switch (m_nPBListType)
		{
		case PB_BROWSER_PAGE_LIST:
			m_pRangeList = new PageRangeList();
			break;
		case PB_BROWSER_LAYER_LIST:
			m_pRangeList = new SheetRangeList();
			break;
		case PB_BROWSER_OBJECT_LIST:
			//-------Folger 07/13/07 CREATE_MATRIX_OBJECT_LIST_TO_SUPPORT_MATRIX_RANGE_SELECTION
			//m_pRangeList = new ColumnRangeList();
			if (vnTypeList.GetSize() && vnTypeList[0] == EXIST_WKS)
				m_pRangeList = new ColumnRangeList();
			else
				m_pRangeList = new MatObjRangeList();
			//-------End CREATE_MATRIX_OBJECT_LIST_TO_SUPPORT_MATRIX_RANGE_SELECTION
			break;
		default:
			break;
		}
		//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
		//------ CPY 9/28/2007 COMPILE_OC_FAILED
		//m_dwFilter = dwFilter;//m_bResultSheet = bResultSheet;		//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
		m_dwFilter = bResultSheet? 0 : SCD_NO_RESULT_SHEET;
		//------
	}
	///Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
	/*
	LPCSTR lpcszDefault : the string should follow these formats
	Folder : /folder1/folder2/
	Page   : Book1
	Layer  : [Book1]Sheet1
	*/
	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	void	SetDefaultShow(LPCSTR lpcszDefault)
	{
		if( NULL != lpcszDefault )
			m_strDefaultShow = lpcszDefault;
	}
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	///End SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
private:
	int 						m_nSelectedMode;	///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION
	int 						m_nPBListType;
	PBSplliter					m_PBList;
	string 						m_strDlgTitle;
	
	string 						m_strSelectedPages;

	vector<uint>				m_vnFolderListGroup;
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	//vector<uint>				m_vnNameGroup;
	//vector<uint>				m_vnTypeGroup;
	vector<uint> 				m_vnBottomGroup;
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	bool						m_bNoCleanList; //----- CPY 12/2/05 DBL_CLICK_CLOSE_ENDED_LIKE_CANCEL 
	///Joseph  09/04/06 ADD_PREVIEW_ON_PROJECT_BROWSER
	bool 						m_bShowGraphPreview;	
	PictureControl 				m_pcPrev;		
	///End ADD_PREVIEW_ON_PROJECT_BROWSER
	
	/// YuI 12/08/06 QA70-9150 EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	string						m_strDefaultShow;///Jasmine 12/26/06 SHOW_DEFAULT_FLD_OR_PAGE_OR_LAYER
	/// end EXTENDED_GUI_FOR_INTERCATIVE_CONTROL
	
	//GridListControl				m_colList;	///Jasmine, Folger 05/05/07 QA80-9654 IMPROVE_PB_FOR_COLUMN_BROWSER
	//-------Folger 07/05/07 USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
	ColumnRangeList				m_colList;	///Jasmine 07/03/07 v8.0654 SUPPORT_RANGE_SELECTION
	PBRangeListBase				*m_pRangeList;
	//-------end USE_PB_RANGE_LIST_BASE_TO_IMPLEMENT_DYNAMIC_BIDING
	DWORD m_dwFilter;//bool						m_bResultSheet;		//---------Folger 07/13/07 EXCLUDE_RESULT_SHEET_IN_COLUMN_BROWSER_IS_NEEDED	///Jasmine 09/28/07 FILTER_OUT_NON_IMAGE_MATRIX	
};
#endif //_PB_H
